    clear all;
    close all;

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    %r=[0:0.1:16] 
    %y = zeros(length(r),1);
    figure;
    hold on;
    %plot(r,y,'--k');
    
    
    n = 8;
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
   
%Plot Data    
        
    [~,idx1] = max(Data(:,2));
    plot(1./Data(1:idx1,1),log(Data(1:idx1,2)));
    
    
    end
    
    
    xlabel('T (K)','fontsize',18,'fontname','times');
    ylabel('R (\Omega)','fontsize',18,'fontname','times');   
    set(gca,'fontsize',18,'fontname','times');
    set(gcf,'color','w'); 
    set(findall(gca, 'Type', 'Line'),'LineWidth',2);
    set(gcf, 'Position', [50, 50, 600, 550])
    set(gca,'fontsize',18,'fontname','times');
    %xlim([1.8 6]);
    box on;
    hold off;
        
    